
#include <cassert>  /* assert */
#include "utils.h"  /* utils function prototypes */

bool before(Date d1, Date d2) {
    /* we assume the year is the same */
    assert(d1.year() == d2.year());
    return ((d1.month() < d2.month()) || 
            ((d1.month() == d2.month()) && (d1.day() < d2.day())));
}

int difference(Date d1, Date d2) {
    /* return days(d1 - d2) */
    assert(before(d2, d1));
    return 30*(d1.month() - d2.month()) + (d1.day() - d2.day());
}

int duration(Date d1, Date d2) {
    /* Here we use a ternary conditional:
     * See https://en.wikipedia.org/wiki/%3F:#C++ */
    return (before(d1,d2) ? difference(d2,d1) : difference(d1,d2));
}
